#!/usr/bin/perl -w
# This script takes a bunch of world image files and converts certain tiles
# to jungle like tiles.

#                        110_116 111_116
#107_117 108_117 109_117 110_117 111_117
#        108_118 109_118 110_118 111_118
#107_119 108_119 109_119 110_119 111_119
#107_120 108_120 109_120 110_120 111_120 112_120
#                109_121 110_121 111_121 112_121
#	         109_122 110_122 111_122

#110_116 and 111_116 are already the dark forest, so don't change those.  For
#the rest, global search and replace these -

# Here is the command used to change the tiles.
$SED=join(" ", "sed %I",
"-e s/desert\$/forestsparse/", 
"-e s/steppe\$/jungle_1/", 
"-e s/grass\$/jungle_2/",
"-e s/brush\$/evergreens/", 
"-e s/grassmedium\$/evergreens2/", 
"-e s/grassdark\$/fernsdense/", 
"-e s/hills_rocky\$/treed_hills/", 
">%O");

use Cwd;
$cwd = cwd();


sub forest ($$) {
    my ($dx, $dy) = @_;
    my $cmd = $SED;
    $cmd =~ s#%I#$cwd/world/b_world_$dx\_$dy#;
    $cmd =~ s#%O#$cwd/world/world_$dx\_$dy#;
    system("cp -f $cwd/world/world_$dx\_$dy $cwd/world/b_world_$dx\_$dy");
    system($cmd);
    print ".";
}


print "Processing.";

forest(107, 117);
forest(107, 119);
forest(107, 120);
forest(112, 120);
forest(112, 121);

$NUM_X=4;
$NUM_Y=4;

$START_X=108;
$START_Y=117;

for ($x=0; $x<$NUM_X; $x++) {
    for ($y=0; $y<$NUM_Y; $y++) {
	forest($x + $START_X, $y + $START_Y);
    }
}

$NUM_X=3;
$NUM_Y=2;

$START_X=109;
$START_Y=121;

for ($x=0; $x<$NUM_X; $x++) {
    for ($y=0; $y<$NUM_Y; $y++) {
	forest($x + $START_X, $y + $START_Y);
    }
}

print "\n";

